'
' Egzemplarze tej klasy reprezentuj token nieterminalny
' AndCombination.
'
Public Class AndCombination
    Implements ICombination
    Private leftChild, rightChild As ICombination

    ' Konstruktor
    ' left - Lewy lewy potomek tego obiektu.
    ' right - Pprawy potomek tego obiektu.
    Public Sub New(ByVal left As ICombination, ByVal right As ICombination)
        leftChild = left
        rightChild = right
    End Sub

    '
    ' Metoda Contains zwraca tablic pozycji tych wyrazw w acuchu
    ' wejciowym, ktre speniaj wymagania stawiane przez oba obiekty
    ' potomne tego egzemplarza klasy AndCombination. Jeli jednak wszystkie
    ' wyrazy w danym acuchu speniaj wymagania obu obiektw potomnych,
    ' funkcja Contains zwraca tablic pust. W przeciwnym razie metoda
    ' zwraca warto Nothing.
    '
    ' s - acuchacuch, ktry zostanie przeszukany przez t metod pod ktem
    '     zawierania wymaganego sowa.
    Public Function Contains(ByVal s As String) As Integer() _
    Implements ICombination.Contains
        Dim leftResult As Integer() = leftChild.Contains(s)
        Dim rightResult As Integer() = rightChild.Contains(s)
        If leftResult Is Nothing Or rightResult Is Nothing Then
            Return Nothing
        End If
        If leftResult.Length = 0 Then
            Return rightResult
        End If
        If rightResult.Length = 0 Then
            Return leftResult
        End If
        ' Sortuje wyniki, aby mona je byo porwnywa i scala.
        QSort.sort(leftResult)
        QSort.sort(rightResult)

        ' Zlicza wsplne pozycje, aby okreli, czy takie pozycje w ogle istniej
        ' i ewentualnie jaka jest ich liczba.
        Dim commonCount As Integer = 0
        Dim l As Integer = 0
        Dim r As Integer = 0

        Do While l < leftResult.Length And r < rightResult.Length
            If leftResult(l) < rightResult(r) Then
                l += l
            ElseIf leftResult(l) > rightResult(r) Then
                r += 1
            Else
                commonCount += 1
                l += 1
                r += 1
            End If
        Loop
        If commonCount = 0 Then
            Return Nothing ' Nie istniej wsplne wyniki.
        End If
        ' Scala wsplne wyniki.
        Dim myResult(commonCount) As Integer
        commonCount = 0
        l = 0
        r = 0
        While l < leftResult.Length And r < rightResult.Length
            If leftResult(l) < rightResult(r) Then
                l += 1
            ElseIf leftResult(l) > rightResult(r) Then
                r += 1
            Else
                myResult(commonCount) = leftResult(l)
                commonCount += 1
                l += 1
                r += 1
            End If
        End While
        Return myResult
    End Function 'Contains
End Class 'AndCombination
